/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ClusteringModifier
extends NoLevelsModifier
implements MeleeDamageModifierHook,
BreakSpeedModifierHook,
TooltipModifierHook,
ConditionalStatModifierHook {
    public float getPercentage(Inventory i) {
        int sizeInv = i.m_6643_();
        float current = 0.0f;
        float sum = 0.0f;
        while (sizeInv-- > 0) {
            ItemStack stackInv = i.m_8020_(sizeInv);
            if (stackInv.m_41619_() || !stackInv.m_204117_(TinkerTags.Items.MODIFIABLE)) continue;
            ToolStack toolInv = ToolStack.from((ItemStack)stackInv);
            current += (float)toolInv.getCurrentDurability();
            sum += ((Float)toolInv.getStats().get((IToolStat)ToolStats.DURABILITY)).floatValue();
        }
        return current / sum;
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getEntity();
        Inventory inv = player.m_150109_();
        if ((double)this.getPercentage(inv) <= 0.45) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (0.45f - this.getPercentage(inv)) * 0.4f));
        }
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        Inventory inv;
        float percentage;
        Player player = context.getPlayerAttacker();
        if (player != null && (double)(percentage = this.getPercentage(inv = player.m_150109_())) > 0.45) {
            return damage * (1.0f + (percentage - 0.45f) * 0.4f);
        }
        return damage;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOLTIP, ModifierHooks.MELEE_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.CONDITIONAL_STAT});
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Player player = (Player)living;
        Inventory inv = player.m_150109_();
        float percentage = this.getPercentage(inv);
        if ((double)percentage > 0.45) {
            if (stat == ToolStats.PROJECTILE_DAMAGE) {
                return baseValue * (1.0f + percentage);
            }
        } else if (stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.45f - percentage);
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (player != null && (harvest || tool.hasTag(TinkerTags.Items.RANGED)) && tooltipKey == TooltipKey.SHIFT) {
            Inventory inv = player.m_150109_();
            float percentage = this.getPercentage(inv);
            if (harvest) {
                if ((double)percentage > 0.45) {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.clustering.attack_damage"), (double)(percentage - 0.45f), tooltip);
                } else {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.clustering.mining_speed"), (double)(0.45 - (double)percentage), tooltip);
                }
            } else if ((double)percentage > 0.45) {
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.clustering.projectile_damage"), (double)percentage, tooltip);
            } else {
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.clustering.draw_speed"), (double)(0.45 - (double)percentage), tooltip);
            }
        }
    }
}

